Libname q 'C:\SASCodeforBook\SASDataSets';

	/*Chapter 9, code for developing the covariates*/

data first; set q.frauddata; 
run;
		/*Indicators of receptivity to innovation: redflag system(Q12), medical provider profile (Q13),
		 lists of bad lawyers (Q14), lists of fraud rings (Q15), more resourses (Q17), Better
		coordination (Q18)*/
		
data second;set first;
Title 'Distributions of six indicators of receptivity to innovation 1 = not useful to 7 very useful';
	Proc freq;
	Tables rdflg12 mdprv13 bdlaw14 rings15 more17 cord18; 
run;

Title 'Distributions of six indicators of receptivity to innovation 1 = not useful to 7 very useful';
	Proc means; var rdflg12 mdprv13 bdlaw14 rings15 more17 cord18; 
run;

Title 'Reliability of Scale based on Six Indicators';
Proc corr nomiss alpha;
	var rdflg12 mdprv13 bdlaw14 rings15 more17 cord18;
run;

	/* Note: fac1_1 = receptivity to innovation, fac2_1 = jobs of higher rank */

		/*Validation of measure of receptivity to innovation*/

Title 'insignificant negative rank correlations of design categories and innovation receptivity';
	Proc corr Spearman; 
	var forclass threclas fac1_1;
run;

Title 'For Hypothesis 2, Correlations of receptivity index with anti index';
	Proc corr;
	var fac1_1 antindex nwanti3 nwant3p1; 
run;


Title 'Correlations of receptivity index with indicators of education';
	proc corr ;
	var fac1_1 colgrad somecol edlv38; 
run;


Title 'Correlations of receptivity index with some organizational background characteristics';
	proc corr;
	var fac1_1 colgrad dtitle33 libmu32 indus31; 
run;

		/*Exploration of indicators of jobs with higher rank:  BIPIP36 = Bodily Injury claims rather
than Personal Injury Protection, ColGrad = College Graduate, Dichotomized Job Title =Dtitle33*/

Title 'Means of indicators of jobs with higher rank';
	Proc means;
	var BIPIP36 ColGrad Dtitle33;
run;

Title 'Reliability of scale based on indicators of jobs with higher rank';
	Proc Corr Alpha; 
	var BIPIP36 ColGrad Dtitle33;
run;

Title 'Reliability of scale based on indicators of jobs with higher rank, Listwise deletion';
	Proc Corr Alpha nomiss; 
	var BIPIP36 ColGrad Dtitle33;
run;

Title 'Spearman Correlations of Index of jobs of higher rank (fac2_1)with the design variables';
	Proc Corr Spearman;
	Var forclass threclas fac2_1;
Run;

Title 'For Hypothesis 3, the higher the rank of job the more opposed to the anti index';
	Proc Corr;
	var fac2_1 antindex nwanti3 nwant3p1;
Run;

	/* Title433 1 = claims representatives, 2 =special investigators and field employees,
	3 =claims specialists, 4 = supervisors*/
Title 'The four class typology influences the employees dichotomized anti index score';
	proc sort;
	by title433;
	proc means;
	var dantidex;
	by title433;
run;

/* The syntax in this file is copyright by Robert B. Smith,  2011. */ 
